#include <LiquidCrystal_I2C.h>

byte taste;
const byte entprellen=50;  // Pause in Millisekunden

LiquidCrystal_I2C lcd(0x27,2,1,0,4,5,6,7,3,POSITIVE);


void setup() 
{
  digitalWrite(A0,HIGH);  // Pull-up hochziehen
  lcd.begin(20,4);
  lcd.print(F("Taste: "));  // Da! Das F()-Makro
}

void loop()
{ 
  taste=lese_taste();   // Lese die Tasten aus
  if (taste>0) 
  {
    lcd.setCursor(7,0);
    lcd.print(taste);
  }
}

byte lese_taste()
{
  int tastenwert;
  tastenwert=analogRead(A0);
  if (tastenwert>200) return 0;
  if (tastenwert>150)   // Taste 4?
  {
    delay(entprellen);
    if (analogRead(A0)>150) return 4;
  }
  if (tastenwert>100)   // Taste 3?
  {
    delay(entprellen);
    if (analogRead(A0)>100) return 3;
  }
  if (tastenwert>50)    // Taste 2?
  {
    delay(entprellen);
    if (analogRead(A0)>50) return 2;
  }
  delay(entprellen);    // Bleibt nur Taste 1
  if (analogRead(A0)<51) return 1;
}
